/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import java.nio.file.Path;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.client.api.common.AbstractGlobalConfiguration;

@Immutable
public class ConnectedGlobalConfiguration
extends AbstractGlobalConfiguration {
    public static final String DEFAULT_STORAGE_DIR = "storage";
    private final String serverId;
    private final Path storageRoot;

    private ConnectedGlobalConfiguration(Builder builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.storageRoot = builder.storageRoot != null ? builder.storageRoot : this.getSonarLintUserHome().resolve(DEFAULT_STORAGE_DIR);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Path getStorageRoot() {
        return this.storageRoot;
    }

    @CheckForNull
    public String getServerId() {
        return this.serverId;
    }

    public static final class Builder
    extends AbstractGlobalConfiguration.AbstractBuilder<Builder> {
        private String serverId;
        private Path storageRoot;

        private Builder() {
        }

        public Builder setServerId(String serverId) {
            Builder.validate(serverId);
            this.serverId = serverId;
            return this;
        }

        private static void validate(String serverId) {
            if (!serverId.matches("\\A[a-zA-Z0-9_]+\\z")) {
                throw new IllegalArgumentException("'" + serverId + "' is not a valid server ID");
            }
        }

        public Builder setStorageRoot(Path storageRoot) {
            this.storageRoot = storageRoot;
            return this;
        }

        public ConnectedGlobalConfiguration build() {
            return new ConnectedGlobalConfiguration(this);
        }
    }
}

